import os
import shutil

def create_account_folders(account_id):
    # Define the base directory
    base_directory = "vectordb"

    # Create account directory
    account_directory = os.path.join(base_directory, account_id)
    os.makedirs(account_directory, exist_ok=True)

    # Create chromadb directory and copy the main chromadb folder
    chromadb_source_directory = os.path.join(base_directory, "chromadb")
    chromadb_destination_directory = os.path.join(account_directory, "chromadb")
    os.makedirs(chromadb_destination_directory, exist_ok=True)

    # Copy the main chromadb folder and its contents
    shutil.copytree(chromadb_source_directory, chromadb_destination_directory)

    # Create sourcefiles directory
    sourcefiles_directory = os.path.join(account_directory, "sourcefiles")
    os.makedirs(sourcefiles_directory, exist_ok=True)

    return account_directory, chromadb_destination_directory, sourcefiles_directory
